/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.json.JsonWriter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public record ElasticCommonSchemaProperties(Service service) {
    static final ElasticCommonSchemaProperties NONE = new ElasticCommonSchemaProperties(Service.NONE);

    ElasticCommonSchemaProperties withDefaults(Environment environment) {
        Service service = this.service.withDefaults(environment);
        return new ElasticCommonSchemaProperties(service);
    }

    static String withFallbackProperty(Environment environment, String value, String property) {
        return !StringUtils.hasLength((String)value) ? environment.getProperty(property) : value;
    }

    public void jsonMembers(JsonWriter.Members<?> members) {
        this.service.jsonMembers(members);
    }

    public static ElasticCommonSchemaProperties get(Environment environment) {
        return Binder.get(environment).bind("logging.structured.ecs", ElasticCommonSchemaProperties.class).orElse(NONE).withDefaults(environment);
    }

    public record Service(String name, String version, String environment, String nodeName) {
        static final Service NONE = new Service(null, null, null, null);

        void jsonMembers(JsonWriter.Members<?> members) {
            members.add("service.name", this::name).whenHasLength();
            members.add("service.version", this::version).whenHasLength();
            members.add("service.environment", this::environment).whenHasLength();
            members.add("service.node.name", this::nodeName).whenHasLength();
        }

        Service withDefaults(Environment environment) {
            String name = ElasticCommonSchemaProperties.withFallbackProperty(environment, this.name, "spring.application.name");
            String version = ElasticCommonSchemaProperties.withFallbackProperty(environment, this.version, "spring.application.version");
            return new Service(name, version, this.environment, this.nodeName);
        }
    }

    static class ElasticCommonSchemaPropertiesRuntimeHints
    extends BindableRuntimeHintsRegistrar {
        ElasticCommonSchemaPropertiesRuntimeHints() {
            super(ElasticCommonSchemaProperties.class);
        }
    }
}

